<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->integer('discount');
			$table->datetime('from');
			$table->datetime('to');
			$table->integer('restaurant_id')->unsigned();
			$table->string('pic', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}