<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpeditionTable extends Migration {

	public function up()
	{
		Schema::create('expedition', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('sender_id')->unsigned();
			$table->integer('receiver_id')->unsigned();
			$table->string('reference', 50);
			$table->integer('type_payment');
			$table->integer('type_expedition');
			$table->integer('status');
			$table->float('cost', 200);
			$table->integer('user_id')->unsigned();
			$table->integer('package_nbr');
			$table->timestamps();
			$table->string('code_agence');
		});
	}

	public function down()
	{
		Schema::drop('expedition');
	}
}