<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSiteNewsTable extends Migration {

	public function up()
	{
		Schema::create('site_news', function(Blueprint $table) {
			$table->increments('id');
			$table->string('Image', 50);
			$table->string('title', 100);
			$table->date('date');
			$table->string('description', 255);
			$table->bigInteger('year_id')->unsigned();
			$table->timestamps();
			$table->string('cover');
		});
	}

	public function down()
	{
		Schema::drop('site_news');
	}
}