<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCallLogsTable extends Migration {

	public function up()
	{
		Schema::create('call_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('caller_number');
			$table->string('receiver_number');
			$table->string('src');
			$table->timestamp('duration');
			$table->enum('status', array('answered', 'missed'));
			$table->enum('type', array('ai_inbound', 'inbound', 'outbound'));
			$table->integer('agent_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('call_logs');
	}
}