<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderFlowTwoTable extends Migration {

	public function up()
	{
		Schema::create('order_flow_two', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('contact_id')->unsigned()->nullable();
			$table->double('total');
			$table->enum('status', array('pending', 'paid', 'shipped'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_flow_two');
	}
}