<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('province_id')->references('id')->on('provinces')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notify_users', function(Blueprint $table) {
			$table->foreign('from_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notify_users', function(Blueprint $table) {
			$table->foreign('to_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notify_customers', function(Blueprint $table) {
			$table->foreign('to_customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notify_customers', function(Blueprint $table) {
			$table->foreign('from_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_city_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_customer_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_province_id_foreign');
		});
		Schema::table('notify_users', function(Blueprint $table) {
			$table->dropForeign('notify_users_from_user_id_foreign');
		});
		Schema::table('notify_users', function(Blueprint $table) {
			$table->dropForeign('notify_users_to_user_id_foreign');
		});
		Schema::table('notify_customers', function(Blueprint $table) {
			$table->dropForeign('notify_customers_to_customer_id_foreign');
		});
		Schema::table('notify_customers', function(Blueprint $table) {
			$table->dropForeign('notify_customers_from_user_id_foreign');
		});
	}
}