<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientOld extends Model 
{

    protected $table = 'client_old';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'last_name', 'mobile', 'email', 'iq', 'nationality_id', 'gender', 'passport', 'password', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function nationality()
    {
        return $this->belongsTo('Country', 'nationality_id');
    }

}