<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function clients()
    {
        return $this->hasMany('ClientOld', 'user_id');
    }

    public function address()
    {
        return $this->hasMany('Address', 'user_id');
    }

}