<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientOldTable extends Migration {

	public function up()
	{
		Schema::create('client_old', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('mobile')->nullable();
			$table->string('email')->nullable();
			$table->string('iq')->nullable();
			$table->string('nationality_id', 120)->nullable();
			$table->enum('gender', array('male.female'))->nullable();
			$table->string('passport')->nullable();
			$table->string('password')->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('client_old');
	}
}