<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientTable extends Migration {

	public function up()
	{
		Schema::create('client', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('patient_name')->nullable();
			$table->string('middle_name')->nullable();
			$table->string('middle_name2')->nullable();
			$table->string('last_name')->nullable();
			$table->string('salutation')->nullable();
			$table->enum('patient_gender', array('M', 'F'))->nullable();
			$table->date('dateofbirth')->nullable();
			$table->string('patient_phone')->nullable();
			$table->integer('patient_category_id')->nullable();
			$table->string('patieatient_state')->nullable();
			$table->string('patient_city')->nullable();
			$table->text('patient_address')->nullable();
			$table->string('country')->nullable();
			$table->string('nationality_id')->nullable();
			$table->string('government_identifier')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('identifier_id')->nullable();
			$table->string('custom_field5')->nullable();
			$table->string('custom_list7_value')->nullable();
			$table->string('custom_list5_value')->nullable();
			$table->string('patient_group')->nullable();
			$table->string('agein')->nullable();
			$table->string('preferred_language')->nullable();
			$table->string('patient_area')->nullable();
			$table->string('file_number')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('client');
	}
}