<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('project_id')->unsigned();
			$table->enum('status', array('active', 'completed', 'pending', 'ready', 'onhold'));
			$table->string('file_url', 255);
			$table->string('file_name', 255);
			$table->string('file_type', 255);
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}