<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBendsTable extends Migration {

	public function up()
	{
		Schema::create('bends', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->float('k_factor');
			$table->string('bend_type', 255);
			$table->float('bend_radius');
			$table->float('bend_angle');
			$table->integer('panel_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('bends');
	}
}