<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Panel extends Eloquent {

	protected $table = 'panels';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('status', 'k_factor', 'geometry_data', 'dimensions', 'material_type', 'panel_type', 'project_id');

	public function project()
	{
		return $this->belongsTo('App\Models\Project');
	}

	public function stiffeners()
	{
		return $this->hasMany('App\Models\Stiffener');
	}

	public function bends()
	{
		return $this->hasMany('App\Models\Bend');
	}

	public function Visualizations()
	{
		return $this->hasMany('App\Models\Visualization');
	}

	public function approvalWorkflow()
	{
		return $this->hasOne('App\Models\ApprovalWorkflow');
	}

}