<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'name', 'description', 'status');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function files()
	{
		return $this->hasMany('App\Models\File');
	}

	public function panels()
	{
		return $this->hasMany('App\Models\Panel');
	}

}