<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'image', 'parent_id', 'activated');

	public function parent()
	{
		return $this->belongsTo('Category', 'parent_id');
	}

	public function products()
	{
		return $this->hasMany('Product');
	}

}