<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('customer_id', 'end_date', 'conditions');

	public function products()
	{
		return $this->belongsToMany('Product');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}