<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'name', 'email', 'mobile', 'company_name', 'company_site', 'activated', 'password');

	public function governorates()
	{
		return $this->belongsTo('Governorate', 'governorate_id');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

}