<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\Model;

class Showroom extends Model 
{

    protected $table = 'showrooms';
    public $timestamps = true;
    protected $fillable = array('business_name', 'image', 'description', 'open_hour', 'close_hour', 'location', 'latitude', 'longitude', 'city_id', 'open_day', 'close_day');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function ads()
    {
        return $this->hasMany('Car');
    }

    public function licenses()
    {
        return $this->hasMany('License');
    }

}