<?php

namespace User;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('first_name', 'last_name', 'email', 'password', 'image', 'whatsapp_phone', 'mobile_phone', 'home_phone', 'location', 'latitude', 'longitude', 'city_id', 'social_id', 'social_type', 'status', 'pin_code', 'is_verified');
    protected $visible = array('first_name');

    public function showrooms()
    {
        return $this->hasMany('Showroom');
    }

    public function ads()
    {
        return $this->hasMany('Car');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

}