<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->integer('u_id', true);
			$table->integer('u_reseller_id')->nullable();
			$table->string('u_email', 250)->unique()->nullable();
			$table->string('u_password', 32)->nullable();
			$table->string('u_mobile', 50)->nullable();
			$table->string('u_salt', 32)->nullable();
			$table->text('u_name');
			$table->text('u_firstname');
			$table->tinyInteger('u_isEmailValid');
			$table->text('u_avatar')->nullable();
			$table->string('u_locale', 5)->nullable();
			$table->integer('u_admin_status')->nullable();
			$table->tinyInteger('u_debugMode')->default('0');
			$table->integer('current_account');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}