<?php

class Account extends Eloquent {

	protected $table = 'accounts';
	public $timestamps = false;

	public function account_resellers()
	{
		return $this->belongsTo('Reseller');
	}

	public function account_users()
	{
		return $this->belongsToMany('User', 'a_id', 'u_id')->wothPivot('users_accounts');
	}

	public function account_plan()
	{
		return $this->hasOne('AccountsPlan', 'a_id');
	}

	public function account_channels()
	{
		return $this->hasMany('Channel', 'a_id');
	}

}