<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuotesTable extends Migration {

	public function up()
	{
		Schema::create('quotes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->string('description', 255)->nullable();
			$table->bigInteger('lead_id')->unsigned();
			$table->bigInteger('contact_id')->unsigned();
			$table->integer('address_id');
			$table->integer('user_created_id')->unsigned();
			$table->string('status', 16)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('quotes');
	}
}