<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ClientProperty extends Eloquent {

	protected $table = 'clientproperties';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'property_name', 'property_details');

	public function client()
	{
		return $this->belongsTo('App\Client', 'client_id');
	}

}