<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lead extends Eloquent {

	protected $table = 'leads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'source', 'status');

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

	public function created_by()
	{
		return $this->belongsTo('App\User', 'user_created_id');
	}

	public function assigned_to()
	{
		return $this->belongsTo('App\User', 'user_assigned_id');
	}

	public function monitored_by()
	{
		return $this->belongsToMany('App\User', 'user_monitor_id');
	}

	public function quotes()
	{
		return $this->hasMany('App\Quote', 'lead_id');
	}

}