<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Quote extends Eloquent {

	protected $table = 'quotes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'description', 'address_id', 'status');

	public function lead()
	{
		return $this->belongsTo('App\Lead', 'lead_id');
	}

	public function contact()
	{
		return $this->hasOne('App\Contact', 'contact_id');
	}

	public function address()
	{
		return $this->hasOne('App\Addressbook', 'address_id');
	}

	public function created_by()
	{
		return $this->belongsTo('App\User', 'user_created_id');
	}

}