<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserInfoTable extends Migration {

	public function up()
	{
		Schema::create('user_info', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('passcode')->nullable();
			$table->enum('unit_type', array('metric', 'imperial'))->nullable();
			$table->float('height')->nullable();
			$table->integer('goal_weight')->nullable();
			$table->integer('goal_steps')->nullable();
			$table->integer('goal_water')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_info');
	}
}