<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryMenTable extends Migration {

	public function up()
	{
		Schema::create('Delivery_men', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('status', array('connected', 'disconnected'));
			$table->boolean('is_busy');
			$table->string('national_number');
			$table->string('license_photo');
			$table->string('disclaimer_photo')->nullable();
			$table->string('identity_photo');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Delivery_men');
	}
}