<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFamiliesTable extends Migration {

	public function up()
	{
		Schema::create('families', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id')->unsigned();
			$table->integer('applicant_id')->unsigned();
			$table->string('family_member');
			$table->string('name');
			$table->string('occupation');
			$table->string('gender');
			$table->string('religion');
			$table->string('birth_place');
			$table->date('birth_date');
			$table->string('phone');
			$table->string('address');
			$table->boolean('mortality_sts');
			$table->timestamps();
			$table->softDeletes();
			$table->string('img_birth_cert');
		});
	}

	public function down()
	{
		Schema::drop('families');
	}
}