<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBillTable extends Migration {

	public function up()
	{
		Schema::create('bill', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('vendor_id')->nullable();
			$table->datetime('issue_date')->nullable();
			$table->datetime('due_date')->nullable();
			$table->datetime('supply_date')->nullable();
			$table->text('notes')->nullable();
			$table->integer('country_id')->nullable();
			$table->string('mall_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bill');
	}
}