<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartnerTable extends Migration {

	public function up()
	{
		Schema::create('partner', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('phone')->nullable();
			$table->double('percent')->nullable();
			$table->double('total')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('partner');
	}
}