<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Adresse extends Model 
{

    protected $table = 'adresses';
    public $timestamps = true;
    protected $fillable = array('id_countrie', 'id_institution', 'city', 'postal_code', 'street', 'state', 'country');
    protected $visible = array('id_countrie', 'id_institution', 'city', 'postal_code', 'street', 'state', 'country');

    public function institution()
    {
        return $this->belongsTo('App\Institution', 'id_intitution');
    }

    public function countrie()
    {
        return $this->belongsTo('App\Countrie', 'id_countrie');
    }

}