<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDispositionsTable extends Migration {

	public function up()
	{
		Schema::create('dispositions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('forward');
			$table->string('content');
			$table->bigIncrements('priority_id');
			$table->string('expired_date');
			$table->string('note');
			$table->string('read_at');
			$table->bigIncrements('incoming_mail_id');
			$table->bigIncrements('user_id');
		});
	}

	public function down()
	{
		Schema::drop('dispositions');
	}
}