<?php

namespace App/Model/;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('phone', 'email', 'password', 'name', 'd_o_b', 'blood_type_id', 'last_donation_data', 'city_id', 'pin_code');

    public function posts()
    {
        return $this->belongsToMany('App/Model/\Post');
    }

    public function notiifications()
    {
        return $this->belongsToMany('App/Model/\Notification');
    }

    public function governorate()
    {
        return $this->belongsToMany('App/Model/\Governorate');
    }

    public function bloodTypes()
    {
        return $this->belongsToMany('App/Model/\Blood_type');
    }

    public function bloodType()
    {
        return $this->hasOne('App/Model/\Blood_type');
    }

    public function city()
    {
        return $this->hasOne('App/Model/\City');
    }

    public function donationRequest()
    {
        return $this->belongsTo('App/Model/\Donation_request');
    }

}