<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketClassesTable extends Migration {

	public function up()
	{
		Schema::create('ticket_classes', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->integer('event_id')->unsigned();
			$table->decimal('price', 10,10);
			$table->integer('tickets_count')->unsigned();
			$table->integer('booked_tickets_count')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('ticket_classes');
	}
}