<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Book extends Eloquent {

	protected $table = 'books';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'details', 'summary', 'language', 'pages_count', 'views', 'author_id', 'category_id', 'file');

	public function author()
	{
		return $this->belongsTo('App\Models\User', 'author_id');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

	public function users_evaluations()
	{
		return $this->hasMany('App\Models\Book', 'book_id');
	}

	public function books_favorite()
	{
		return $this->hasMany('App\Models\BookFavorite', 'book_id');
	}

}