<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('company_id', 'role_id', 'username', 'name', 'email', 'password', 'remember_token');
    protected $visible = array('company_id', 'role_id', 'username', 'name', 'email', 'password', 'remember_token');

    public function comments()
    {
        return $this->hasMany('Comment');
    }

    public function tasks()
    {
        return $this->belongsToMany('Ticket', 'user_tickets', 'user_id', 'ticket_id');
    }

    public function role()
    {
        return $this->belongsTo('Role');
    }

}