<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Comment extends Eloquent {

	protected $table = 'comments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('status_id', 'comment_id', 'ticket_id', 'user_id', 'detail');
	protected $visible = array('status_id', 'comment_id', 'ticket_id', 'user_id', 'detail');

	public function comment()
	{
		return $this->belongsTo('Comment');
	}

	public function task()
	{
		return $this->belongsTo('Ticket');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function replies()
	{
		return $this->belongsTo('Comment');
	}

	public function attachments()
	{
		return $this->morphToMany('Attachment');
	}

}