<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('veron_id', 'status', 'name', 'email', 'phone', 'website');
    protected $visible = array('veron_id', 'status', 'name', 'email', 'phone', 'website');

    public function projects()
    {
        return $this->belongsTo('Project');
    }

    public function contracts()
    {
        return $this->hasMany('Contract');
    }

}