<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->timestamps();
			$table->string('username');
			$table->string('name');
			$table->string('password');
			$table->date('dob');
			$table->bigInteger('nationality')->unsigned()->nullable();
			$table->string('email')->unique();
			$table->bigInteger('role_id');
			$table->date('birth_date');
			$table->string('phone');
			$table->bigInteger('national_id')->nullable();
			$table->bigInteger('branch_id')->unsigned()->index();
			$table->bigInteger('city_id')->unsigned();
			$table->string('job_degree');
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}