<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupplyBondItemsTable extends Migration {

	public function up()
	{
		Schema::create('supply_bond_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('bond_id')->unsigned();
			$table->string('line_id');
			$table->integer('kind_id')->unsigned();
			$table->bigInteger('karat_id')->unsigned();
			$table->double('weight')->nullable();
			$table->integer('sahm')->nullable();
			$table->integer('wage')->nullable();
			$table->string('total_wage')->nullable();
			$table->double('wage_tax');
			$table->double('gold_wage')->nullable();
			$table->integer('number')->nullable();
			$table->integer('value')->nullable();
			$table->double('value_tax')->nullable();
			$table->double('stone_weight')->nullable();
			$table->string('other_stone_weight')->nullable();
			$table->double('discount')->nullable();
			$table->longText('notes')->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->bigInteger('parent_id')->unsigned()->index();
			$table->double('remaining_weight')->nullable();
			$table->enum('status', array('closed', 'opend'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('supply_bond_items');
	}
}