<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBanksTable extends Migration {

	public function up()
	{
		Schema::create('banks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->bigInteger('country_id')->unsigned()->index();
			$table->integer('city_id')->unsigned()->nullable()->index();
			$table->string('branch')->nullable();
			$table->string('main_account_number')->nullable();
			$table->string('iban_number')->nullable();
			$table->string('swift_number')->nullable();
			$table->string('account_short_name')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('banks');
	}
}