<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCardsTable extends Migration {

	public function up()
	{
		Schema::create('cards', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('company_name')->nullable();
			$table->string('branch')->nullable();
			$table->integer('card_type_id')->unsigned()->index();
			$table->integer('banck_id')->unsigned()->index();
			$table->integer('banck_account_id')->unsigned()->index();
			$table->integer('commission_rate')->nullable();
			$table->integer('maximum_limit')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cards');
	}
}