<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateKindsTable extends Migration {

	public function up()
	{
		Schema::create('kinds', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->enum('type', array('single', 'multi'))->nullable();
			$table->enum('has_sizes', array('true', 'false'))->nullable();
			$table->enum('has_selsal', array('true', 'false'))->nullable();
			$table->enum('selling_by_weight', array('true', 'false'))->nullable();
			$table->enum('selling_by_piece', array('true', 'false'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('kinds');
	}
}