<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationBondsTable extends Migration {

	public function up()
	{
		Schema::create('reservation_bonds', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('date');
			$table->morphs('user');
			$table->double('tax_value');
			$table->enum('type', array('test'));
			$table->double('total_gold_value');
			$table->double('total_weight');
			$table->double('total_tax');
		});
	}

	public function down()
	{
		Schema::drop('reservation_bonds');
	}
}