<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupplyBondPaymentTable extends Migration {

	public function up()
	{
		Schema::create('supply_bond_payment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('date');
			$table->integer('supplier_id')->unsigned();
			$table->string('bond_number');
			$table->string('bond_docs');
			$table->string('notes');
			$table->double('total_tax');
			$table->string('type');
			$table->double('total_money');
			$table->double('total_24_for_shears');
			$table->decimal('total_18');
			$table->double('total_21');
			$table->double('total_22');
			$table->double('total_24');
			$table->double('discount');
		});
	}

	public function down()
	{
		Schema::drop('supply_bond_payment');
	}
}