<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_group_id')->references('id')->on('user_group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('system_route', function(Blueprint $table) {
			$table->foreign('system_part_id')->references('id')->on('system_part')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_system_part', function(Blueprint $table) {
			$table->foreign('user_group_id')->references('id')->on('user_group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_system_part', function(Blueprint $table) {
			$table->foreign('system_part_id')->references('id')->on('group_system_part')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_persmission', function(Blueprint $table) {
			$table->foreign('user_group_id')->references('id')->on('user_group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_persmission', function(Blueprint $table) {
			$table->foreign('field_permission_id')->references('id')->on('field_permission')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('log_data', function(Blueprint $table) {
			$table->foreign('log_id')->references('id')->on('log')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_group_id_foreign');
		});
		Schema::table('system_route', function(Blueprint $table) {
			$table->dropForeign('system_route_system_part_id_foreign');
		});
		Schema::table('group_system_part', function(Blueprint $table) {
			$table->dropForeign('group_system_part_user_group_id_foreign');
		});
		Schema::table('group_system_part', function(Blueprint $table) {
			$table->dropForeign('group_system_part_system_part_id_foreign');
		});
		Schema::table('user_persmission', function(Blueprint $table) {
			$table->dropForeign('user_persmission_user_group_id_foreign');
		});
		Schema::table('user_persmission', function(Blueprint $table) {
			$table->dropForeign('user_persmission_field_permission_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_user_id_foreign');
		});
		Schema::table('log_data', function(Blueprint $table) {
			$table->dropForeign('log_data_log_id_foreign');
		});
	}
}