<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class System_part extends Eloquent {

	protected $table = 'system_part';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function system_route()
	{
		return $this->hasMany('App\Models\System_route', 'system_part_id');
	}

	public function user_group_part()
	{
		return $this->hasMany('App\Models\Group_system_part', 'system_part_id');
	}

}