<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExperimentTargetMetricsTable extends Migration {

	public function up()
	{
		Schema::create('ExperimentTargetMetrics', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('experiment_id')->unsigned();
			$table->integer('targetmetric_id')->unsigned();
			$table->float('baseline_value');
			$table->float('target_value');
			$table->float('power');
			$table->float('significance');
			$table->integer('min_participants')->unsigned()->nullable();
			$table->float('std_dev');
		});
	}

	public function down()
	{
		Schema::drop('ExperimentTargetMetrics');
	}
}