<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Treatment', function(Blueprint $table) {
			$table->foreign('experiment_id')->references('id')->on('Experiment')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ExperimentTargetMetrics', function(Blueprint $table) {
			$table->foreign('experiment_id')->references('id')->on('Experiment')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ExperimentTargetMetrics', function(Blueprint $table) {
			$table->foreign('targetmetric_id')->references('id')->on('TargetMetric')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ExperimentConflict', function(Blueprint $table) {
			$table->foreign('conflict_experiment_id')->references('id')->on('Experiment')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ExperimentConflict', function(Blueprint $table) {
			$table->foreign('experiment_id')->references('id')->on('Experiment')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('TreatmentStatusService', function(Blueprint $table) {
			$table->foreign('experiment_id')->references('id')->on('Experiment')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('TreatmentStatusService', function(Blueprint $table) {
			$table->foreign('treatment_id')->references('id')->on('Treatment')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('Treatment', function(Blueprint $table) {
			$table->dropForeign('Treatment_experiment_id_foreign');
		});
		Schema::table('ExperimentTargetMetrics', function(Blueprint $table) {
			$table->dropForeign('ExperimentTargetMetrics_experiment_id_foreign');
		});
		Schema::table('ExperimentTargetMetrics', function(Blueprint $table) {
			$table->dropForeign('ExperimentTargetMetrics_targetmetric_id_foreign');
		});
		Schema::table('ExperimentConflict', function(Blueprint $table) {
			$table->dropForeign('ExperimentConflict_conflict_experiment_id_foreign');
		});
		Schema::table('ExperimentConflict', function(Blueprint $table) {
			$table->dropForeign('ExperimentConflict_experiment_id_foreign');
		});
		Schema::table('TreatmentStatusService', function(Blueprint $table) {
			$table->dropForeign('TreatmentStatusService_experiment_id_foreign');
		});
		Schema::table('TreatmentStatusService', function(Blueprint $table) {
			$table->dropForeign('TreatmentStatusService_treatment_id_foreign');
		});
	}
}