<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('payment_id');
			$table->integer('checkout_id');
			$table->integer('user_id');
			$table->float('sub_total');
			$table->integer('cart_id');
			$table->float('discount');
			$table->float('total');
			$table->string('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}